#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Hexagonal Truchet Flow TestMod01.fsh  by   Kamoshika
//https://www.shadertoy.com/view/Nddczr
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//#define AA 1

// If you have a strong PC, make it bigger.
#define AA 3

const float sqrt3 = sqrt(3.);
const float PI = acos(-1.);
const float PI2 = acos(-1.) * 2.;

float hash12(in vec2 v) {
    return fract(sin(dot(v, vec2(12.9898, 78.233))) * 43758.5453);
}

mat2 rotate2D(in float a) {
    float s = sin(a);
    float c = cos(a);
    return mat2(c, s, -s, c);
}

vec3 render(in vec2 p) {
    vec3 col = vec3(0);
    
    float scale = 3.;
    
    // Log-polar coordinates.
    p = vec2(log(length(p)) - iTime * 0.5, atan(p.y, p.x));
    p *=  sqrt3 / PI * scale * 0.5;
    
    // Hexagonal tiling.
    vec2 c = normalize(vec2(1, sqrt3));
    vec2 h = c * 0.5;
    vec2 a = mod(p, c) - h;
    vec2 b = mod(p - h, c) - h;
    vec2 g = dot(a, a) < dot(b, b) ? a : b;
    
    //vec2 ID = floor(mod(p - g + 1e-4, s * scale) / h);
    p = p - g + 1e-4;
    p.y = mod(p.y, sqrt3 * scale);
    vec2 ID = floor(p / h);
    
    float n = floor(hash12(ID) * 3.);
    g *= rotate2D(n * PI / 3.);
    g.y = abs(g.y);
    float d = g.y;
    g.y -= 0.5 / sqrt3;
    
    float e;
    if(g.y > -0.375 / sqrt3) {
        // Circle.
        e = atan(g.y, g.x) * 9.;
    } else {
        // Line.
        e = (0.75 - g.x * 10.) * PI2;
    }
    
    d = min(d, abs(length(g) - 0.25 / sqrt3));
    col += vec3(1) * smoothstep(0.08, 0., d);
    
    float dir = sign(mod(n, 2.) - 0.5); // Direction of movement.
    col *= sin(e - dir * iTime * 9.) * 0.4 + 0.6;
    
    return col;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec3 col = vec3(0);
    
    // Anti-aliasing.
    for(int m = 0; m < AA; m++) {
        for(int n = 0; n < AA; n++) {
            vec2 of = vec2(m, n) / float(AA) - 0.5;
            vec2 p = ((fragCoord + of) * 2. - iResolution.xy) / min(iResolution.x, iResolution.x);
            col += render(p);
        }
    }
    col /= float(AA * AA);
    
    fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

